/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entity.render;

import com.ferreusveritas.dynamictrees.entity.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.models.FallingTreeEntityModel;
import com.ferreusveritas.dynamictrees.models.FallingTreeEntityModelTrackerCache;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FallingTreeRenderer
extends EntityRenderer<FallingTreeEntity> {
    public FallingTreeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(FallingTreeEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public void render(FallingTreeEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        if (!entity.isClientBuilt() || !entity.shouldRender()) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTextureLocation(entity));
        FallingTreeEntityModel treeModel = FallingTreeEntityModelTrackerCache.getOrCreateModel(entity);
        poseStack.m_85836_();
        VertexConsumer vertexBuilder = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entity)));
        entity.currentAnimationHandler.renderTransform(entity, entityYaw, partialTick, poseStack);
        treeModel.m_7695_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

